;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   UART_1.inc
;;  Version: 5.0.0.12, Updated on 2004/07/02 at 16:59:36
;;  Generated by PSoC Designer ver 4.2 BETA b1005 : 09 July, 2004
;;
;;  DESCRIPTION:  Assembler declarations for the UART user module for the
;;                22/24/25/26/27xxx PSoC family of devices.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

;--------------------------------------------------
; Constants for UART_1 API's
;--------------------------------------------------

;mask value for global int reg bit for TX instance
UART_1_TX_INT_MASK:                           equ 04h
UART_1_TX_INT_REG:                            equ 0e1h  ;TX interrupt address
UART_1_RX_INT_MASK:                           equ 08h  ;mask value for global int reg bit for RX instance
UART_1_RX_INT_REG:                            equ 0e1h  ;RX interrupt address

UART_1_RXBUF_ENABLE:                        equ   1

; Interrupt control masks
UART_1_ENABLE_RX_INT:                          equ  0x01
UART_1_DISABLE_RX_INT:                         equ  0x00
UART_1_ENABLE_TX_INT:                          equ  0x02
UART_1_DISABLE_TX_INT:                         equ  0x00

UART_1_INT_MODE_TX_REG_EMPTY:                equ 0x00
UART_1_INT_MODE_TX_COMPLETE:                 equ 0x01

UART_1_RX_IGNORE_BELOW:                      equ  20h
UART_1_RX_BUFFER_SIZE:                       equ  10h
UART_1_CMD_TERM:                             equ  dh
UART_1_DELIMITER:                            equ  20h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       WARNING WARNING WARNING
; The following equates are for backwards
; compatibility only and should not be used
; for new designs.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;------------------------------------
;  Parity masks
;------------------------------------
UART_PARITY_NONE:       equ   00h
UART_PARITY_EVEN:       equ   02h
UART_PARITY_ODD:        equ   06h

;------------------------------------
;  TX Status Register masks
;------------------------------------
UART_TX_COMPLETE:       equ   20h
UART_TX_BUFFER_EMPTY:   equ   10h

;------------------------------------
;  RX Status Register masks
;------------------------------------
UART_RX_ACTIVE:         equ   10h
UART_RX_COMPLETE:       equ   08h
UART_RX_PARITY_ERROR:   equ   80h
UART_RX_OVERRUN_ERROR:  equ   40h
UART_RX_FRAMING_ERROR:  equ   20h
UART_RX_NO_ERROR:       equ   E0h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             END WARNING
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;------------------------------------
;  Parity masks
;------------------------------------
UART_1_PARITY_NONE:                     equ   00h
UART_1_PARITY_EVEN:                     equ   02h
UART_1_PARITY_ODD:                      equ   06h

;------------------------------------
;  TX Status Register masks
;------------------------------------
UART_1_TX_COMPLETE:                     equ   20h
UART_1_TX_BUFFER_EMPTY:                 equ   10h

;------------------------------------
;  RX Status Register masks
;------------------------------------
UART_1_RX_ACTIVE:                       equ   10h
UART_1_RX_COMPLETE:                     equ   08h
UART_1_RX_REG_FULL:                     equ   08h
UART_1_RX_PARITY_ERROR:                 equ   80h
UART_1_RX_OVERRUN_ERROR:                equ   40h
UART_1_RX_FRAMING_ERROR:                equ   20h
UART_1_RX_ERROR:                        equ   E0h
UART_1_RX_ENABLE:                       equ   01h

UART_1_RX_BUF_ERROR:                    equ   F0h  ; Mask for any Rx that may occur.
UART_1_RX_BUF_OVERRUN:                  equ   10h  ; This indicates the software buffer has
                                                        ; been over run.
UART_1_RX_BUF_CMDTERM:                  equ   01h  ; Command terminator has been received.

UART_1_RX_NO_DATA:                      equ   01h
UART_1_RX_NO_ERROR:                     equ   E0h


;--------------------------------------------------
; Registers Address Constants for UART_1
;--------------------------------------------------
;---------------------------------
;  Registers used by TX
;---------------------------------
UART_1_TX_CONTROL_REG:  equ 2bh            ; Control register
UART_1_TX_SHIFT_REG:    equ 28h               ; TX Shift Register register
UART_1_TX_BUFFER_REG:   equ 29h               ; TX Buffer Register
UART_1_TX_FUNC_REG: equ 28h             ; Function register
UART_1_TX_INPUT_REG:    equ 29h            ; Input register
UART_1_TX_OUTPUT_REG:   equ 2ah           ; Output register

;---------------------------------
;  Registers used by RX
;---------------------------------
UART_1_RX_CONTROL_REG:  equ 2fh            ; Control register
UART_1_RX_SHIFT_REG:    equ 2ch               ; RX Shift Register register
UART_1_RX_BUFFER_REG:   equ 2eh               ; RX Buffer Register
UART_1_RX_FUNC_REG: equ 2ch             ; Function register
UART_1_RX_INPUT_REG:    equ 2dh            ; Input register
UART_1_RX_OUTPUT_REG:   equ 2eh           ; Output register

; end of file UART_1.inc
